<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<p><table class="formatted" cellpadding=0 cellspacing=0 width=540>
<tr><th>Help</th></tr>
<tr><td>

<p>Use the menu displayed at the top of every page to get around the site.
Below is a description of each page. <i>Note that you will need to login in
order to access most pages.</i></p>

<p><a href="default.asp">Home</a><br>
This is the first page displayed after you log in. Check here for news and
any update information.</p>

<p><a href="entry.asp">Enter Picks</a><br>
You may enter for the current week or make selections in advance for upcoming
weeks using the links provided.</p>

<p>To enter, select a winner (or call a tie) for each game. The winner will be
the player with the most correct guesses for the week. In the event of a tie,
the player who guesses closest to the total points scored in the <b>Monday
Night Football</b> game will win.</p>

<p>Picks may be changed at any time as long as the game has not been locked.
<b>Thursday, Friday</b> and <b>Saturday</b> games are locked at the start of
the individual game. Remaining games for the current week are locked at the
start of the first game on <b>Sunday.</b> All times listed on the schedules
are Eastern.</p>

<p>To change any of your picks or tie breaker points, go to the
<a href="entry.asp">Enter Picks</a> page. Your current picks and points will be
shown. Make your changes and hit the Submit button.</p>

<p>You cannot make or change a pick for locked games. If you did not make a
pick for a game that has been locked, it is counted as a loss.</p>

<p><a href="results.asp">View Results</a><br>
This page shows each player's picks and score for a given week. Game scores
will be updated as they arrive. All game results should be in by late Monday
night or early Tuesday morning.</p>

<p>Results for each week's pool are generated automatically so once all scores
are in, the winner will be declared.</p>

<p><a href="summary.asp">Season Summary</a><br>
Lists the winners for each week's pool along with individual summaries of each
player's winnings (or losses) and overall performance.</p>

<p><a href="weekly.asp">Weekly Schedule</a><br>
Let's you view the schedule week-by-week. By default the current week will be
displayed but you can jump to any week using the links at the bottom of the
page. The display includes scores when available.</p>

<p><a href="team.asp">Team Schedules</a><br>
Select a team from the drop-down list to view it's schedule. Each week's games
are shown with the date, time and score when available.</p>

<p><a href="standings.asp">Standings</a><br>
Displays the current standings for all NFL teams. You can also click on a team
name to jump to it's schedule.</p>

<p><a href="password.asp">Change Password</a><br>
You can change your password here. You must enter you current password and then
the new password twice in the spaces provided (this helps prevent typos since
you can't see what you type in the fields). Then be sure to use the new one the
next time you log in.</p>

<p>For your protection, passwords are stored in encrypted format. If you forget
your password, contact the <a href="mailto:admin@example.net">Administrator</a>
and you'll be issued a new one.</p>

<p><a href="logout.asp">Login/Logout</a><br>
Login here with your username and password. You may not access most pages on
the site until you've successfully logged in.</p>

<p>If you are inactive for several minutes, your session may timeout. When this
happens, the next time you try to access a page you will automatically be sent
back to the login page. Just sign in again and you may then continue with
whatever you where doing.</p>

<p>You may also use this link to logout and end your session. This can be used
to allow someone else to login with their own username and password.</p>

<p>If you're having trouble logging in, contact the
<a href="mailto:admin@example.net">Administrator</a>.</p>

<p><a href="help.asp">Help</a><br>
You can always come to this page for help with finding your way around or
entering and updating your picks.</p>
<% if Session("PoolUsername") = ADMIN_USERNAME then %>

<p><a href="scores.asp">Enter Scores</a> (Administrator only)<br>
Use this form to update individual games scores. By default games for the
current week will be displayed but you can jump to any week using the links at
the bottom of the page.</p>

<p>You need not fill in all the scores at once, just leave the fields blank if
you do not have the final score for a given game. You can also correct scores
simply by changing the field value and submitting the form.</p>

<p>The OT field should be checked to indicate an overtime game. This has no
bearing on the pool but it does appear in the schedule displays.</p>

<p><a href="users.asp">Update Users</a> (Administrator only)<br>
Here you can add and delete users or reset any user's password. Although all
users are listed, only one user can be updated or added at a time.</p>

<p>Note that if a user is deleted, only the username and password are removed
from the database. Any pool entries for that user remain intact but are ignored
when calculating the results. If you later add that user name back, those
entries will again be associated with the name and counted in the results.</p>
<% end if %>
</td></tr>
</table></p>

<!-- #include file="footer.inc" -->
